#pragma compile(Icon, Icon.ico)
#pragma compile(UPX, True)
#pragma compile(Stripper, True)
#pragma compile(FileVersion, 1.0.0.0)
#pragma compile(ProductVersion, 1.0.0.0)
#pragma compile(ProductName, RW)
#pragma compile(FileDescription, Run AutoIt Script Wrapper)
#pragma compile(LegalCopyright,  G.Sandler)
#pragma compile(CompanyName, CreatoR's Lab)
#pragma compile(Comments, Program made by G.Sandler)

#NoTrayIcon
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <ComboConstants.au3>
#include <Array.au3>
#include <File.au3>

If $CmdLine[0] = 0 Then
	MsgBox(48, @ScriptName, 'Executed without arguments.')
	Exit
EndIf

Global $sAutoItInstallDir = RegRead('HKEY_LOCAL_MACHINE\SOFTWARE\AutoIt v3\AutoIt', 'InstallDir')
Global $sAutoItVersDir = _PathFull(IniRead(@ScriptDir & '\RW.ini', 'Main', 'AutoIt Vers Dir', ''), @ScriptDir)

Global $aAutoItDirs = _FileListToArray($sAutoItVersDir, '*', 2, False)
Global $aAutoItDirs_Beta = _FileListToArray($sAutoItVersDir & '\Beta', '*', 2, False)

If Not IsArray($aAutoItDirs) Then
	MsgBox(48, @ScriptName, 'AutoIt Dirs not found.')
	Exit
EndIf

$hGUI = GUICreate('AutoIt Run Wrapper', 300, 250)

$iSelAutoItDir_Radio = GUICtrlCreateRadio('AutoIt Dir:', 20, 15)
$iAutoItDirs_Combo = GUICtrlCreateCombo('', 20, 40, 260, 50, BitOR($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
_SetCombo($iAutoItDirs_Combo, $aAutoItDirs, $sAutoItVersDir)
GUICtrlSetState($iSelAutoItDir_Radio, $GUI_CHECKED)

$iSelAutoItDir_Beta_Radio = GUICtrlCreateRadio('AutoIt Beta Dir:', 20, 85)
$iAutoItDirs_Beta_Combo = GUICtrlCreateCombo('', 20, 110, 260, 50, BitOR($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
_SetCombo($iAutoItDirs_Beta_Combo, $aAutoItDirs_Beta, $sAutoItVersDir & '\Beta')

GUICtrlSetState($iAutoItDirs_Beta_Combo, $GUI_DISABLE)

$x64_CB = GUICtrlCreateCheckbox('x64', 20, 160)

$iRun_Bttn = GUICtrlCreateButton('Run', 20, 210, 60, 20)
$iCancel_Bttn = GUICtrlCreateButton('Cancel', 220, 210, 60, 20)

GUISetState(@SW_SHOW, $hGUI)

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE, $iCancel_Bttn
			Exit
		Case $iRun_Bttn
			GUISetState(@SW_HIDE, $hGUI)
			
			$sX64 = ''
			
			If GUICtrlRead($x64_CB) = $GUI_CHECKED Then
				$sX64 = '_x64'
			EndIf
			
			If GUICtrlRead($iSelAutoItDir_Radio) = $GUI_CHECKED Then
				Run('"' & $sAutoItVersDir & '\' & GUICtrlRead($iAutoItDirs_Combo) & '\AutoIt3' & $sX64 & '.exe" "' & $CmdLine[1] & '"')
			Else
				Run('"' & $sAutoItVersDir & '\Beta\' & GUICtrlRead($iAutoItDirs_Beta_Combo) & '\AutoIt3' & $sX64 & '.exe" "' & $CmdLine[1] & '"')
			EndIf
			
			If @error Then
				MsgBox(48, @ScriptName, 'Unable to run the script, please check path to AutoIt versions dir in config file.')
			EndIf
			
			Exit
		Case $iSelAutoItDir_Radio
			GUICtrlSetState($iAutoItDirs_Combo, $GUI_ENABLE)
			GUICtrlSetState($iAutoItDirs_Beta_Combo, $GUI_DISABLE)
		Case $iSelAutoItDir_Beta_Radio
			GUICtrlSetState($iAutoItDirs_Combo, $GUI_DISABLE)
			GUICtrlSetState($iAutoItDirs_Beta_Combo, $GUI_ENABLE)
	EndSwitch
WEnd

Func _SetCombo($iCombo, $aDirs, $sPath)
	If Not IsArray($aDirs) Then
		Return SetError(1, 0, 0)
	EndIf
	
	Local $sData = ''
	Local $sDefault = $aDirs[1]
	
	For $i = 1 To $aDirs[0]
		If FileExists($sPath & '\' & $aDirs[$i] & '\AutoIt3.exe') And $aDirs[$i] <> 'Beta' Then
			If $sData Then
				$sData &= '|'
			EndIf
			
			If $sPath & '\' & $aDirs[$i] = $sAutoItInstallDir Then
				$sDefault = $aDirs[$i]
			EndIf
			
			$sData &= $aDirs[$i]
		EndIf
	Next
	
	GUICtrlSetData($iCombo, $sData, $sDefault)
EndFunc
